package cn.com.duiba.tuia.adx.center.api.dto.consumer;

import cn.com.duiba.tuia.adx.center.api.constant.SlotLoginType;
import cn.com.duiba.tuia.adx.center.api.constant.SexType;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

/**
 * 给推啊游戏用户体系专用缓存类
 * 此类会在用户通过各种途径登录时候缓存到redis集群中，key为"TPW-USER-userId"
 * Created by youhaijun on 2017/12/11.
 */
public class ConsumerCache implements Serializable {

    public static final String REDIS_KEY = "TPW-USER-";
    private static final long serialVersionUID = -1343495073452182848L;

    /**
     * 用户ID，发号器产生
     */
    private Long userId;

    private Long appId;
    /**
     * 性别
     *
     * @see SexType
     */
    private Integer sex;

    /**
     * 昵称
     */
    private String nickName;
    /**
     * 头像
     */
    private String img;
    /**
     * 登录类型
     *
     * @see SlotLoginType
     */
    private Integer loginType;

    /**
     * 用户标识
     */
    private String deviceId;

    /**
     * 登陆时间　０　普通登陆　１　首次登陆　２　每日首次登陆
     */
    private Integer loginTime;

    public ConsumerCache() {
    }

    public ConsumerCache(Long userId, Long appId, String deviceId) {
        this.userId = userId;
        this.appId = appId;
        this.deviceId = deviceId;
    }
    public ConsumerCache(Long userId, Long appId, Integer sex, String nickName, String img, Integer loginType, String deviceId) {
        this.userId = userId;
        this.sex = sex;
        this.nickName = nickName;
        this.img = img;
        this.loginType = loginType;
        this.appId = appId;
        this.deviceId = deviceId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public Integer getLoginType() {
        return loginType;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(Integer loginTime) {
        this.loginTime = loginTime;
    }

    public String toJsonString(){
        return JSONObject.toJSONString(this);
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public static ConsumerCache parseJsonString(String jsonString){
        return JSONObject.parseObject(jsonString, ConsumerCache.class);
    }

}
