package cn.com.duiba.tuia.adx.center.api.dto.consumer.req;

import cn.com.duiba.tuia.adx.center.api.constant.BalanceRecordType;
import cn.com.duiba.tuia.adx.center.api.constant.BalanceType;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class BalanceRecordAdd implements Serializable {

    // 货币数量
    private Long              amount;

    // 人命币数量
    private Long              rmbAmount;
    // 记录类型
    private BalanceRecordType recordType;
    // 用户id
    private Long              userId;
    // 货币类型
    private BalanceType balanceType;

    private Long              appId;
    private Long              slotId;
    private Long              pageId;
    private String            extInfo;

    public Long getRmbAmount() {
        return rmbAmount;
    }

    public void setRmbAmount(Long rmbAmount) {
        this.rmbAmount = rmbAmount;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public BalanceType getBalanceType() {
        return balanceType;
    }

    public void setBalanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public BalanceRecordType getRecordType() {
        return recordType;
    }

    public void setRecordType(BalanceRecordType recordType) {
        this.recordType = recordType;
    }

    public void setPageIdAndGameIdToExtInfo(Long pageId,Long gameId) {
        JSONObject jsonObject;
        if (StringUtils.isNoneBlank(this.getExtInfo())) {
            jsonObject = JSONObject.parseObject(this.getExtInfo());
        } else {
            jsonObject = new JSONObject();
        }
        jsonObject.put("pageId",pageId);
        jsonObject.put("gameId",gameId);
        this.setExtInfo(jsonObject.toJSONString());
    }
}
