/**
 * Copyright (c) 2020, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.dto.dpa;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述: 广告位算法特征
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2020/7/30 14:57
 */
@Data
public class SlotAlgoFeatureDTO implements Serializable {
    private static final long serialVersionUID = 2001858075218207782L;

    /* 广告位ID */
    private Long slotId;

    /* 广告位资源位状态 */

    /* 广告位返回拦截状态 */
    private Integer interceptorStatus;

    /* 广告位浮标状态 */
    private Integer buoyStatus;

    /* 广告位推荐弹层状态 */
    private Integer recommendStatus;

    /* 增值状态 0-关 1-开 */
    private Integer encStatus;

}
