package cn.com.duiba.tuia.adx.center.api.dto.plant;

import cn.com.duiba.tuia.adx.center.api.constant.ErrorCode;

import java.io.Serializable;

/**
 * [种红包]检查Dto
 *
 * @author zhangbaiqiang
 * @date 2018/11/21
 */
public class CheckDto implements Serializable {
    private static final long serialVersionUID = 2626360120218589107L;

    /**
     * 是否成功
     */
    private Boolean isSuccess;

    /**
     * 错误码
     */
    private String code;

    /**
     * 错误信息
     */
    private String msg;

    public CheckDto() {
        this.isSuccess = true;
        this.code = ErrorCode.E0000000.getErrorCode();
        this.msg = ErrorCode.E0000000.getDesc();
    }

    public CheckDto(ErrorCode errorCode) {
        this.isSuccess = false;
        this.code = errorCode.getErrorCode();
        this.msg = errorCode.getDesc();
    }

    public CheckDto(String errorCode, String errorMsg) {
        this.isSuccess = false;
        this.code = errorCode;
        this.msg = errorMsg;
    }

    public Boolean getSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
