package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.BetGameHistoryDto;
import cn.com.duiba.tuia.adx.center.api.dto.BetGameResultDto;
import cn.com.duiba.tuia.adx.center.api.dto.BetGameTimeDto;
import cn.com.duiba.tuia.adx.center.api.dto.UserBetAmountDto;
import cn.com.duiba.tuia.adx.center.api.dto.UserBetDto;

@AdvancedFeignClient
public interface RemoteBetGameService {
    /**
     * 获取当前游戏进行到的时间
     */
    BetGameTimeDto getNowTime(Long id);

    UserBetAmountDto getBetAmount(Long userId, Long gameId);
    /**
     *
     * @param userBetDto
     * @return 更新后
     */
    Boolean updateAmountToRedis(UserBetDto userBetDto);

    /**
     * 查询历史结果
     * @param gameId
     * @return
     */
    BetGameHistoryDto getHistoryResult(Long gameId);


    BetGameResultDto getResult(Long gameId, Long userId);
}
