package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.PublicNoticeStyleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 中奖公示样式
 * Created by xuefeng on 2017/12/29.
 */
@AdvancedFeignClient
public interface RemotePublicNoticeStyleService {

    /**
     * 获取所有样式
     *
     * @return
     */
    DubboResult<List<PublicNoticeStyleDto>> getAll();

    /**
     * 分页获取样式
     *
     * @param rowStart
     * @param pageSize
     * @return
     */
    DubboResult<PageDto<PublicNoticeStyleDto>> getByPage(Integer rowStart, Integer pageSize);

    /**
     * 根据id获取样式
     *
     * @param id
     * @return
     */
    DubboResult<PublicNoticeStyleDto> getById(Long id);

    /**
     * 添加样式
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> add(PublicNoticeStyleDto dto);

    /**
     * 更新样式
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> update(PublicNoticeStyleDto dto);

    /**
     * 删除样式
     *
     * @param id
     * @return
     */
    DubboResult<Boolean> remove(Long id);
}
