package cn.com.duiba.tuia.adx.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.bean.dto.AdContentDTO;
import cn.com.duiba.tuia.adx.center.api.bean.dto.SeatDetailDTO;
import cn.com.duiba.tuia.adx.center.api.bean.dto.SlotDTO;
import cn.com.duiba.tuia.adx.center.api.bean.dto.SlotDisplayDTO;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface Remote2345AdxSlotService {
    /**
     * 分页查询2345ADX广告位
     * @param pageNumber
     * @param pageSize
     * @return 广告位集合
     */
    PageDto<SlotDTO> pageQuerySlot(Integer pageNumber, Integer pageSize);

    /**
     * 查询所有的广告位
     * @return
     */
    List<SlotDTO> queryAllSlot();

    /**
     * 根据广告位Id集合查询详情(最大10个)
     * @param seatIds 广告位Id集合
     * @return 广告位详情集合
     */
    List<SeatDetailDTO> queryForList(List<Integer> seatIds);

    /**
     * 判断多个广告位 样式是否相同
     * @param seatIds
     * @return true相同  false不相同
     */
    Boolean isSameDisplayStyle(List<Integer> seatIds);

    /**
     * 根据广告位Id查询广告样式
      * @param slotId
     * @return
     */
    List<SlotDisplayDTO> getBySlotId(Integer slotId);

    /**
     * 封装广告物料
     * @param resourceIdeaId 创意Id
     * @param seatId 广告位Id
     * @return 广告物料模型
     */
    List<AdContentDTO> getAdContent(Long resourceIdeaId, Integer seatId);

    /**
     * 获取remote广告样式列表
     * @param seatIds
     * @return
     */
    Map<String, List<SeatDetailDTO>> getRemoteSeatDetailMap(List<Integer> seatIds);

    /**
     * 数据修复
     * @return
     */
    Boolean dataRecovery();


}
