package cn.com.duiba.tuia.adx.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.adx.AdvertisingSpaceStyleDetailDto;
import cn.com.duiba.tuia.adx.center.api.dto.adx.AdvertisingSpaceStyleDto;
import cn.com.duiba.tuia.adx.center.api.dto.adx.AdvertisingSpaceStyleInsertDto;
import cn.com.duiba.tuia.adx.center.api.dto.adx.AdvertisingSpaceStyleUpdateDto;

import java.util.List;

/**
 * @author shenjiaqing
 * @description 广告位样式功能开发
 * @data 2019/11/20
 */
@AdvancedFeignClient
public interface RemoteAdvertisingSpaceStyleService {

    boolean delete(Long id);

    boolean deleteByAdTypeId(Long adTypeId);

    AdvertisingSpaceStyleDto getAdSpaceStyleById(Long id);

    List<Long> getAdStyleIdByAdTypeId(Long adTypeId);

    List<AdvertisingSpaceStyleDto> getAdSpaceStyleByAdTypeId(Long adTypeId);

    List<AdvertisingSpaceStyleDto> getAllAdSpaceStyle();

    List<AdvertisingSpaceStyleDto> getAdSpaceStyleByAdTypeIdList(List<Long> adTypeIdList);

    AdvertisingSpaceStyleDetailDto getAdSpaceStyleDetailById(Long adStyleId);

    boolean templateIdIsExists(String styleStandard, Long id, Long adTypeId);

    boolean adStyleNameIsExists(String adStyleName, Long id, Long adTypeId);

    boolean insert(AdvertisingSpaceStyleInsertDto dto);

    boolean update(AdvertisingSpaceStyleUpdateDto dto);

    boolean adStyleIsExists(Long id);

    Long selectAdTypeIdById(Long id);


    List<AdvertisingSpaceStyleDetailDto> selectByAdTypeId( Long adTypeId);

    /**
     * 墨迹样式迁移
     * @return
     */
    boolean mojiStyleInitialize();

    boolean mojiStyleTransfer();

    boolean mojiResourcePosIdBind();

    boolean mojiStyleAndMaterialInitialize();
}
