package cn.com.duiba.tuia.adx.center.api.remoteservice.algo;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.algo.AlgoDTO;
import cn.com.duiba.tuia.adx.center.api.dto.algo.ReqAlgo;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 *  @author: xuesong
 *  @Date: 2019-12-06 17:13
 *  @Description: 算法remote
 */ 
@AdvancedFeignClient
public interface RemoteAlgoService {


    /**
     *  算法列表
     */
    DubboResult<PageResultDto<AlgoDTO>> listAlgo(ReqAlgo req);


    /**
     *  添加算法
     */
    DubboResult<Boolean> addAlgo(AlgoDTO dto);


    /**
     *  修改算法
     */
    DubboResult<Boolean> updateAlgo(AlgoDTO dto);


    /**
     *  发布算法
     */
    DubboResult<Boolean> publishAlgo(Long id, String operatorName);

    /**
     *  获取发布中的算法
     */
    DubboResult<AlgoDTO> useAlgo();
}
