package cn.com.duiba.tuia.adx.center.api.remoteservice.card;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.card.ActivityCardDto;
import cn.com.duiba.tuia.adx.center.api.dto.card.CardCollectDto;
import cn.com.duiba.tuia.adx.center.api.dto.card.CardCollectOrderDto;
import cn.com.duiba.tuia.adx.center.api.dto.card.CardCollectUserDto;

import java.util.List;

/**
 * 描述：集卡
 *
 * @author weny.cai
 * @date 2018/10/8 14:10
 **/
@AdvancedFeignClient
public interface RemoteCardCollectService {

    /**
     * 添加集卡
     * @param activityCardDto
     * @return
     */
    Boolean addActivityCards(ActivityCardDto activityCardDto) throws BizException;


    /**
     * 更新集卡
     * @param activityCardDto
     * @return
     */
    Boolean updateActivityCards(ActivityCardDto activityCardDto) throws BizException;


    /**
     * 根据活动ID
     * 获取集卡信息
     * @param activityId
     * @return
     */
    ActivityCardDto getActivityCards(Long activityId) throws BizException;


    /**
     * 扣库存操作
     */
    Boolean consumeStock(Long activityId, Long consumerId, CardCollectDto cardCollectDto) throws BizException;


    /**
     * 是否生成集卡订单
     * 如果集卡成功
     * 销毁卡片
     * 返回exchangeToken
     */
    String createCardOrder(Long activityId, Long consumerId, Integer cardCollectSize);


    /**
     * 获取用户集卡的信息
     */
    List<CardCollectDto> getUserCardsInfo(Long activityId, Long consumerId);


    /**
     * 获取用户当前
     * 订单接口
     */
    List<CardCollectOrderDto> getUserCardOrders(Long activityId, Long consumerId);


    List<CardCollectUserDto> getUserCardCollect(Long activityId, Long consumerId);


    /**
     * 删除需要自动清空的活动的所有用户集卡记录
     * @return
     */
    void deleteAutoClearCards();

}
