package cn.com.duiba.tuia.adx.center.api.remoteservice.commercial.plant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.CommercialUserReq;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.PlantV5UserReq;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.plant.LotteryDto;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.plant.PropDto;

/**
 * RemotePlantV5Service
 *
 * @author huangruodan
 * @date 2019-07-04
 */

@AdvancedFeignClient
public interface RemotePlantV5Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(PlantV5UserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req      用户参数
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantV5UserReq req) throws BizException;

    /**
     * 采摘红包
     *
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantV5UserReq userReq) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req       用户参数
     * @param missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(CommercialUserReq req, String missionId) throws BizException;

    /**
     * 用户使用道具，
     *
     * @param req
     * @param landId
     * @param propType
     * @return
     * @throws BizException
     */
    PropDto useProp(CommercialUserReq req, Integer landId, Integer propType) throws BizException;

    /**
     * @param req
     * @return
     * @throws BizException
     */
    LotteryDto lotteryEveryday(PlantV5UserReq req) throws BizException;


    /**
     * @param req
     * @return
     * @throws BizException
     */
    int finishVat(CommercialUserReq req) throws BizException;

    /**
     * 换天接口
     * @param deviceId
     * @param appId
     * @param date
     * @return
     * @throws BizException
     */
    Boolean resetForTest(String deviceId, Long appId, String date) throws BizException;
}
