/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.bean.dto;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public class AdxReport {
    private Integer exposureNumber = 0;
    private Integer clickNumber = 0;
    private Double clickRate = 0.0;
    private Double cost = 0.0;
    private Double averageBid = 0.0;
    private Double cpc = 0.0;

    public static void convert(Integer exposureNumber, Integer clickNumber, String price, AdxReport adxReport) {
        if (adxReport != null && adxReport.getExposureNumber() != null) {
            adxReport.setExposureNumber(adxReport.getExposureNumber() + exposureNumber);
        }
        if (adxReport != null && adxReport.getClickNumber() != null) {
            adxReport.setClickNumber(adxReport.getClickNumber() + clickNumber);
        }
        if (adxReport != null && StringUtils.isNotBlank((String)price)) {
            BigDecimal oldValue = new BigDecimal(adxReport.getCost().toString());
            BigDecimal newValue = new BigDecimal(price);
            adxReport.setCost(oldValue.add(newValue).setScale(3, 4).doubleValue());
        }
    }

    public static void compute(AdxReport adxReport) {
        if (adxReport != null && adxReport.getExposureNumber() != null && adxReport.getClickNumber() != null && adxReport.getClickNumber() != 0 && adxReport.getExposureNumber() != 0) {
            BigDecimal exposureNumber = new BigDecimal(adxReport.getExposureNumber().toString());
            BigDecimal clickNumber = new BigDecimal(adxReport.getClickNumber().toString());
            BigDecimal hundred = BigDecimal.TEN.multiply(BigDecimal.TEN);
            adxReport.setClickRate(clickNumber.divide(exposureNumber, 4, 4).multiply(hundred).setScale(2, 4).doubleValue());
            BigDecimal cost = new BigDecimal(adxReport.getCost().toString());
            adxReport.setAverageBid(cost.divide(exposureNumber, 6, 4).multiply(BigDecimal.TEN.multiply(hundred)).setScale(2, 4).doubleValue());
            adxReport.setCpc(cost.divide(clickNumber, 2, 4).doubleValue());
        }
    }

    public Integer getExposureNumber() {
        return this.exposureNumber;
    }

    public void setExposureNumber(Integer exposureNumber) {
        this.exposureNumber = exposureNumber;
    }

    public Integer getClickNumber() {
        return this.clickNumber;
    }

    public void setClickNumber(Integer clickNumber) {
        this.clickNumber = clickNumber;
    }

    public Double getClickRate() {
        return this.clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public Double getCost() {
        return this.cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public Double getAverageBid() {
        return this.averageBid;
    }

    public void setAverageBid(Double averageBid) {
        this.averageBid = averageBid;
    }

    public Double getCpc() {
        return this.cpc;
    }

    public void setCpc(Double cpc) {
        this.cpc = cpc;
    }
}

