/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.constant;

import org.apache.commons.lang3.RandomUtils;

public enum PlantPrizeType {
    COUPON(1, "\u5238"),
    CASH(2, "\u73b0\u91d1"),
    LAND(3, "\u89e3\u9501\u571f\u5730"),
    SEED(4, "\u89e3\u9501\u79cd\u5b50"),
    BLOCK(5, "\u533a\u5757"),
    ENCOURAGE(6, "\u6fc0\u52b1\u5e7f\u544a"),
    FIRST_PRIZE(7, "\u65b0\u624b\u5956\u52b1"),
    KETTLE(8, "\u6c34\u58f6\u9053\u5177"),
    LOTTERY_TIMES(9, "\u62bd\u5956\u6b21\u6570"),
    EMPTY(10, "\u7a7a");

    private Integer type;
    private String desc;

    private PlantPrizeType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static PlantPrizeType randomType(int couponProb) {
        return RandomUtils.nextInt((int)1, (int)101) <= couponProb ? COUPON : CASH;
    }

    public static PlantPrizeType randomType(int couponProb, int stageSignDays) {
        if (stageSignDays < 4) {
            return RandomUtils.nextInt((int)1, (int)101) <= couponProb ? COUPON : CASH;
        }
        if (stageSignDays < 5) {
            int randomInt = RandomUtils.nextInt((int)1, (int)101);
            if ((double)randomInt < (double)couponProb - 10.0) {
                return COUPON;
            }
            if (randomInt < couponProb) {
                return LOTTERY_TIMES;
            }
            return CASH;
        }
        int randomInt = RandomUtils.nextInt((int)1, (int)101);
        if ((double)randomInt < (double)couponProb - 10.0 - 30.0) {
            return COUPON;
        }
        if ((double)randomInt < (double)couponProb - 30.0) {
            return LOTTERY_TIMES;
        }
        if (randomInt < couponProb) {
            return EMPTY;
        }
        return CASH;
    }
}

