/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.constant.adx;

import java.util.Objects;

public enum ConnetType {
    UNKNOW(1, "\u672a\u77e5"),
    INNET(2, "\u4ee5\u592a\u7f51"),
    WIFI(3, "wifi"),
    G2(4, "2G"),
    G3(5, "3G"),
    G4(6, "4G");

    private int type;
    private String desc;

    private ConnetType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isSameType(Integer connectType) {
        return Objects.nonNull(connectType) && Objects.equals(this.type, connectType) || this.equals((Object)UNKNOW);
    }

    public static ConnetType convertLiebaoToTuiaType(Integer liebaoType) {
        if (Objects.equals(liebaoType, 2)) {
            return WIFI;
        }
        return UNKNOW;
    }

    public static ConnetType convertSougouToTuiaType(Integer sougouType) {
        for (ConnetType connetType : ConnetType.values()) {
            if (!connetType.isSameType(sougouType)) continue;
            return connetType;
        }
        return UNKNOW;
    }

    public static ConnetType convertMojiToTuiaType(Integer mojiType) {
        if (Objects.equals(mojiType, 1)) {
            return WIFI;
        }
        if (Objects.equals(mojiType, 2)) {
            return G2;
        }
        if (Objects.equals(mojiType, 3)) {
            return G3;
        }
        if (Objects.equals(mojiType, 4)) {
            return G4;
        }
        return UNKNOW;
    }
}

