/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.constant.commercial.plant;

import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;

public enum SeedType {
    TOMATO(1, 14, 40, "\u897f\u7ea2\u67ff"),
    CORN(2, 3, 40, "\u7389\u7c73"),
    PUMPKIN(3, 2, 50, "\u5357\u74dc"),
    PITAYA(4, 1, 50, "\u706b\u9f99\u679c"),
    IPHONE(5, 0, 0, "iPhone\u7ea2\u5305");

    private Integer type;
    private Integer weight;
    private Integer cashPercent;
    private String desc;

    private SeedType(Integer type, Integer weight, Integer cashPercent, String desc) {
        this.type = type;
        this.weight = weight;
        this.cashPercent = cashPercent;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public Integer getCashPercent() {
        return this.cashPercent;
    }

    public String getDesc() {
        return this.desc;
    }

    public int countMatureTime(int times) {
        int matureTime = 0;
        switch (this) {
            case TOMATO: {
                if (times <= 3) {
                    matureTime = RandomUtils.nextInt((int)2, (int)4);
                    break;
                }
                if (times <= 6) {
                    matureTime = RandomUtils.nextInt((int)5, (int)11);
                    break;
                }
                if (times <= 10) {
                    matureTime = RandomUtils.nextInt((int)60, (int)601);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)43200, (int)54001);
                break;
            }
            case CORN: {
                if (times <= 1) {
                    matureTime = RandomUtils.nextInt((int)5, (int)11);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)60, (int)601);
                break;
            }
            case PUMPKIN: {
                if (times <= 1) {
                    matureTime = RandomUtils.nextInt((int)10, (int)16);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)3600, (int)7201);
                break;
            }
            case PITAYA: {
                matureTime = RandomUtils.nextInt((int)3600, (int)7201);
                break;
            }
        }
        return matureTime;
    }

    public static SeedType valueOf(Integer type) {
        for (SeedType typeEnum : SeedType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static Integer getCashPercent(Integer type) {
        for (SeedType typeEnum : SeedType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum.cashPercent;
        }
        return null;
    }
}

