/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.duiba.tuia.adx.center.api.common.BaseDto;
import cn.com.duiba.tuia.adx.center.api.constant.AlipayType;
import cn.com.duiba.tuia.adx.center.api.dto.AccountRechargeDto;
import cn.com.duiba.tuia.adx.center.api.dto.ApiRechargeDto;
import cn.com.duiba.tuia.adx.center.api.dto.CouponsCodeDto;
import cn.com.duiba.tuia.adx.center.api.dto.PrizeDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class VirtualGoodsInfoDto
extends BaseDto {
    private static final long serialVersionUID = -3081469676034835097L;
    private Integer virtualType;
    private Integer subType;
    private Long prizeId;
    private String extInfo;

    public VirtualGoodsInfoDto() {
    }

    public VirtualGoodsInfoDto(String extInfo) {
        this.extInfo = extInfo;
    }

    public Integer getVirtualType() {
        return this.virtualType;
    }

    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }

    public Integer getSubType() {
        return this.subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getPrizeId() {
        return this.prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public void setExtInfoByValue(PrizeDto dto) {
        if (dto == null) {
            return;
        }
        Integer accountSwitch = dto.getAccountSwitch();
        List<AccountRechargeDto> list = dto.getAccountRechargeDto();
        HashMap map = null;
        if (AlipayType.VIRTUAL_API.getType().equals(this.getVirtualType())) {
            map = new HashMap(3);
            ApiRechargeDto apiDto = dto.getApiRechargeDto();
            map.put("apiRecharge", apiDto);
            map.put("accountSwitch", accountSwitch);
            map.put("accountInfo", BaseDto.isEmpty(list) ? Collections.emptyList() : list);
        } else if (AlipayType.VIRTUAL_TICKET.getType().equals(this.getVirtualType())) {
            map = new HashMap(1);
            CouponsCodeDto couponsDto = dto.getCouponsCodeDto();
            map.put("coupons", couponsDto);
        } else if (AlipayType.VIRTUAL_ACCOUNT.getType().equals(this.getVirtualType())) {
            map = new HashMap(2);
            map.put("accountSwitch", accountSwitch);
            map.put("accountInfo", BaseDto.isEmpty(list) ? Collections.emptyList() : list);
        } else if (AlipayType.VIRTUAL_RED_PACKET.getType().equals(this.getVirtualType())) {
            map = new HashMap(1);
            map.put("redPacket", dto.getRedPacket());
        } else if (AlipayType.JUMP_QUICK_APPLICATION.getType().equals(this.getVirtualType())) {
            map = Maps.newHashMap();
            map.put("quickApplicationRecharge", dto.getQuickApplicationRechargeDto());
        } else if (AlipayType.JUMP_H5.getType().equals(this.getVirtualType())) {
            map = Maps.newHashMap();
            map.put("h5Recharge", dto.getH5RechargeDto());
        }
        this.setExtInfo(JSON.toJSONString(map));
    }
}

