/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    private static CloseableHttpClient createDefault() {
        return HttpClientBuilder.create().build();
    }

    public static String get(String url) {
        try {
            CloseableHttpClient client = HttpUtil.createDefault();
            HttpGet request = new HttpGet(url);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String post(String url, Map<String, Object> params) {
        BufferedReader in = null;
        try {
            CloseableHttpClient client = HttpUtil.createDefault();
            HttpPost request = new HttpPost(url);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (String key : params.keySet()) {
                String value = String.valueOf(params.get(key));
                nvps.add(new BasicNameValuePair(key, value));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
            HttpResponse response = client.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            logger.info("\u8bf7\u6c42URL\uff1a" + url + ";code\uff1a" + code);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String post(String url, String params) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        StringEntity entity = new StringEntity(params, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            logger.info("\u8bf7\u6c42URL\uff1a" + url + ";code\uff1a" + code);
            if (code == 200) {
                HttpEntity responseEntity = response.getEntity();
                String jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                return jsonString;
            }
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

