/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.dto.unit.filter;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 描述: 创意素材描述过滤条件
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/19 12:26
 */
@Data
@NoArgsConstructor
public class MaterialUnitDescFilter implements Serializable {
    private static final long serialVersionUID = 6722070554023028262L;

    /**
     * 最少描述字数
     **/
    private Integer descriptionMinNum;

    /**
     * 最多描述字数
     **/
    private Integer descriptionMaxNum;
}
