/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.dto.unit.filter;

import cn.com.duiba.tuia.adx.center.api.dto.style.AdVideoCoverDTO;
import lombok.Data;

import java.io.Serializable;

/**
 * 描述: 创意素材-素材明细过滤条件
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/19 12:31
 */
@Data
public class MaterialUnitDetailFilter implements Serializable {
    private static final long serialVersionUID = 7826384291988730705L;

    /* 素材类型 1-图片 3-视频 */
    private Integer materialType;

    /** 素材宽度 **/
    private Integer width;

    /** 素材高度 **/
    private Integer height;

    /** 素材大小 单位 kb **/
    private Long size;

    /** 支持的素材格式 **/
    private String format;

    /** 视频时长 **/
    private Double duration;

    /* 最少时长 */
    private Double minDuration;

    /** 视频封面图 **/
    private AdVideoCoverDTO adVideoCoverDTO;
}
