package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.duiba.tuia.adx.center.api.enums.IdeaBidTypeEnum;
import cn.com.duiba.tuia.adx.center.api.enums.UnitPutTypeEnum;
import lombok.Data;
import lombok.ToString;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 创意
 *
 * @author weny.cai
 * @date 2018/12/3 14:27
 **/
@Data
@ToString
public class ResourceIdeaDto implements Serializable {

    private static final long serialVersionUID = 2078063159077522207L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 创意名称
     */
    private String ideaName;

    /**
     * 创意计划开关：0，关闭；1，开启
     */
    private Integer switchState;

    /**
     * 推啊广告位id
     */
    private Long slotId;

    private String ideaTitle;

    private String ideaDesc;

    private Integer budgetType;

    private Double dayBudget;

    private String dayBudgetStr;

    /**
     * 出价（元/CPM）
     */
    private Double ideaPrice;

    /**
     * 出价（元/CPM）
     */
    private String ideaPriceStr;

    private String resourceName;

    private String groupName;

    private Long groupId;

    private Integer adxType;

    private Integer sysState;
    /**
     * 手机品牌名称
     */
    private String brandName;

    private List<String> sysValue;

    private Date gmtCreate;

    private Date gmtModified;

    private ResourceLocationDto resourceLocationDto;

    private List<IdeaPictureDto> ideaPictureDtos;

    /*
     * 创意视频
     */
    private IdeaVideoDto ideaVideo;

    private Integer exposurePv;

    private Integer clickPv;

    /**
     * 消耗
     */
    private String price;

    private String clickRate;

    /**
     * 点击率显示文本
     */
    private String ctrText;

    /**
     * 平均扣费
     */
    private String agvPrice;

    private String cpcPrice;

    /**
     * 出价类型类型 0-- 人工出价 1--算法出价
     */
    private Integer priceType;
    /**
     * 计费类型（暂时只有百度联盟有）
     */
    private Integer chargeType;

    /**
     * 最低 ROI
     */
    private Double minRoi;

    /**
     * 最小创意出价：包含
     */
    private Double minPrice;

    /**
     * 最大创意出价：包含
     */
    private Double maxPrice;

    private Integer timesLimitFlag;

    private Integer timesLimitType;

    private Integer limitNum;

    /**
     * 创意审核状态
     */
    private List<ResourceIdeaAuditDto> resourceIdeaAuditDtoList;
    /**
     * 可投资源位列表
     */
    private List<ShortResourceLocationDto> enableResourceLocations;


    /** 投放地域（0：不限，1：自定义）默认0 */
    private Integer putAreaType;

    /** 区域码（多个以逗号拼接） */
    private String areaCode;

    /** 广告位样式ID **/
    private Long adStyleId;

    /** 广告位样式模版ID **/
    private String templateId;

    private String styleName;

    /** 地域码集合 */
    private List<Long> areaCodeList;

    /**
     * 创意竞价类型：0:互动 1：直投 {@link IdeaBidTypeEnum}
     */
    private Integer             bidType;

    /**
     * Dsp 平台Id
     */
    private Integer dspId;

    /**
     * 广告主id
     */
    private Integer advertiserId;

    /**
     * 广告id
     */
    private Integer advertId;

    /**
     * PMP投放类型，0:RTB，1:PD，2:PDB
     *
     * @see cn.com.duiba.tuia.adx.center.api.enums.PmpType
     */
    private Integer pmpType;

    private Double roi;

    /**
     * 创意出价策略(只在查询单个创意的时候返回，列表的时候注意为空)
     */
    private IdeaPriceStrategyDTO ideaPriceStrategyDTO;

    /**
     * 曝光频次等级：0.不限 1.强 2.中 3.弱
     */
    private Integer frequencyLevel;

    /**
     * 点击频次等级：0.不限 1.强 2.中 3.弱
     */
    private Integer clickFrequencyLevel;

    /**
     * 首次进入限制强弱等级：0.不限 1.强 2.中 3.弱
     * @see cn.com.duiba.tuia.adx.center.api.enums.RequestFilterLevelEnum
     */
    private Integer requestFilterLevel;

    /**
     *  是否开启dpa,0:不开启 1：开启
     */
    private Integer dpaFlag;

    /**
     * dmp人群定向包
     */
    private List<ResourceIdeaCrowdBindDto> orientationCrowds;

    private Set<Integer> orientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> excludeCrowds;

    private Set<Integer> excludeCrowdTypes;

    private Set<Integer> crowdTypes;

    /**
     * adx人群定向包
     */
    private List<ResourceIdeaCrowdBindDto> adxOrientationCrowds;

    private Set<Integer> adxOrientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> adxExcludeCrowds;

    private Set<Integer> adxExcludeCrowdTypes;

    private Set<Integer> adxCrowdTypes;

    /**
     * 媒体人群定向包
     */

    private List<ResourceIdeaCrowdBindDto> mediaOrientationCrowds;

    private Set<Integer> mediaOrientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> mediaExcludeCrowds;

    private Set<Integer> mediaExcludeCrowdTypes;

    private Set<Integer> mediaCrowdTypes;

    private Integer crowdBindType;  //1 不限  2 自定义

    private Integer crowdBindLogicType; //1 定向 2 排除  3 定向+排除

    private Integer adxCrowdBindType;  //1 不限  2 自定义

    private Integer adxCrowdBindLogicType;//1 定向 2 排除  3 定向+排除

    private Integer mediaCrowdBindType;  //1 不限  2 自定义

    private Integer mediaCrowdBindLogicType; //1 定向 2 排除  3 定向+排除

    /**
     * pd预算类型
     */
    private Integer pdbBudgetType;

    /**
     * pd每日预算
     */
    private Double pdbDayBudget;

    /**
     * pd出价类型
     */
    private Integer pdbPriceType;

    /**
     * 是否新架构4.0 0/null-否 1-是
     */
    private Integer isNew;

    /**
     * 创意素材投放方式 1-人工 2-算法
     * @see UnitPutTypeEnum
     */
    private Integer unitPutType;

    /**
     * 创意素材ID展示明细
     */
    private List<MaterialUnitDTO> materialUnitDTOList;

    /**
     * 创意计划多样式
     */
    private List<Long> adStyleIdList;

    /**
     * 投放时间-开始
     */
    private String startDate;

    /**
     * 投放时间-截止
     */
    private String endDate;

    /**
     * 投放时间段
     */
    private String timePeriod;

    /**
     * 投放时间段
     */
    private List<ResourceTimeDto> timeDtos;

    /**
     * 平均扣费
     */
    private String ideaAvgPriceStr;

    /**
     * 资源计划标签对象集合
     */
    private List<ResourceIdeaTagRelationDto> tagRelationData;

    /**
     * 创意计划投放比例
     */
    private Integer deliveryRatio;

    /**
     * 投放管理开关：0.关闭；1.开启
     */
    private Integer deliveryManageSwitch;

    /**
     * 创意名称通配符
     */
    private String ideaNameWildcard;

    private Integer strategyType;

    private Double expectPrice;

    /**
     * 互动链路类型 0 传统互动  1 首发券互动
     */
    private Integer interactLinkType;

    /**
     * 是否定向设备用户：0 否 1 是（DeviceOrientTypeEnum）
     */
    private Integer deviceOrientType;

}

