package cn.com.duiba.tuia.adx.center.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 创意视频 Dto
 * @dateTime 2019-10-18 15:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class IdeaVideoDto implements Serializable {


    private static final long serialVersionUID = -7172957460960979822L;

    /*
     * 自增主键
     */
    private Long id;

    /*
     * 视频广告 Url
     */
    private String videoUrl;

    /*
     * 视频大小 ( 单位 :: Byte )
     */
    private Integer videoSize;

    /*
     * 视频单位 ( 单位 :: Byte )
     */
    private String unit;

    /*
     * 视频时长 ( 单位 :: Secend/秒 )
     */
    private BigDecimal videoDuration;

    /*
     * 视频分辨率水平显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720
     */
    private Integer videoResolutionX;

    /*
     * 视频分辨率垂直显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720
     */
    private Integer videoResolutionY;

    /*
     * 视频封面图片 Url
     */
    private String videoCoverUrl;

    /*
     * 视频封面图片宽度
     */
    private Integer videoCoverWidth;

    /*
     * 视频封面图片高度
     */
    private Integer videoCoverHeight;

    /*
     * Adx 类型
     * -- { 9 : 连尚 }
     */
    private Integer adxType;

    /*
     * 创意 Id
     */
    private Long ideaId;

    /*
     * 删除标识
     * -- { 0 : 未删除 , 1 : 已删除 , 默认 : 0 }
     */
    private Integer isDeleted;

    /* 视频封面图素材ID */
    private Long videoCoverMaterialId;

    /* 视频素材ID */
    private Long videoMaterialId;

    /**
     * 重写 ToString
     * @return 结果
     */
    @Override
    public String toString() {
        StringBuilder builder;
        builder = new StringBuilder(getClass().getSimpleName());
        builder.append(" [ ").append("Hash = ").append(hashCode())
               .append(", id=").append(id)
               .append(", videoUrl=").append(videoUrl)
               .append(", videoSize=").append(videoSize)
               .append(", videoDuration=").append(videoDuration)
               .append(", videoResolutionX=").append(videoResolutionX)
               .append(", videoResolutionY=").append(videoResolutionY)
               .append(", videoCoverUrl=").append(videoCoverUrl)
               .append(", videoCoverWidth=").append(videoCoverWidth)
               .append(", videoCoverHeight=").append(videoCoverHeight)
               .append(", ideaId=").append(ideaId)
               .append(", adxType=").append(adxType)
               .append(", isDeleted=").append(isDeleted)
               .append(", serialVersionUID=").append(serialVersionUID).append(" ]");
        return builder.toString();
    }

}