package cn.com.duiba.tuia.adx.center.api.dto.tuia.adx.request;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2023/11/6.
 */
@Data
public class TuiaAdxImp implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 广告位序号id
     */
    private Integer id;

    /**
     * 广告位id
     */
    private String tagId;

    /**
     * 底价 单位:分
     */
    private Integer floorPrice;

    /**
     * 链接协议
     * true:https
     * false:http
     */
    private Boolean linkAgreement;

    /**
     * 广告位类型
     * 1:信息流
     * 2:激励视频
     * 3:插屏
     * 4:开屏
     * 5:banner
     */
    private Integer adSlotType;

    /**
     * 是否支持deepLink
     * true:支持
     * false:不支持
     */
    private Boolean openDeepLink;

    /**
     * 支持的创意交互类型
     */
    private List<Integer> contentTypes;

    /**
     * 投放素材要求
     */
    private List<TuiaAdxStyleInfo> styleInfos;
}
