package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.tuia.adx.request.PromotionProductPageReq;
import cn.com.duiba.tuia.adx.center.api.dto.tuia.adx.request.PromotionProductReq;
import cn.com.duiba.tuia.adx.center.api.dto.PromotionProductDto;

@AdvancedFeignClient
public interface RemotePromotionProductService {

    //新增产品
    boolean add(PromotionProductReq req) throws BizException;

    //修改产品
    boolean edit(PromotionProductReq req) throws BizException;

    //分页查询
    PageDto<PromotionProductDto> pageQuery(PromotionProductPageReq req);

    //查询详情
    PromotionProductDto getById(Long id);

    //删除产品
    boolean deleteById(Long id) throws BizException;
}
