/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.util;

import cn.com.duiba.tuia.adx.center.api.annotation.ExcelRowIndex;
import cn.com.duiba.tuia.adx.center.api.constant.ErrorCode;
import cn.com.duiba.tuia.adx.center.api.exception.ActivityCenterException;
import cn.com.duiba.wolf.utils.DateUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ExcelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String REQUEST_PARAM_NAME = "file";
    public static final String FILE_SUFFIX_XLS = "xls";
    public static final String FILE_SUFFIX_XLSX = "xlsx";
    private static Map<String, Class<?>> classMap = new HashMap();
    private static final String METHOD_NAME = "valueOf";

    private ExcelUtil() {
    }

    public static <T> List<T> parseExcel(HttpServletRequest request, Class<T> clzz, Boolean ignoreFirstRow) throws ActivityCenterException {
        Workbook wb = ExcelUtil.parseExcelToWorkbook(request);
        Sheet sheet = wb.getSheetAt(0);
        if (Objects.isNull(ignoreFirstRow)) {
            ignoreFirstRow = false;
        }
        return ExcelUtil.parseExcelSheet(sheet, clzz, ignoreFirstRow);
    }

    private static List<Object> parseExcelSheet(Sheet sheet, Class<?> clzz, Boolean ignoreFirstRow) throws ActivityCenterException {
        int index;
        int firstRowIndex = sheet.getFirstRowNum();
        int lastRowIndex = sheet.getLastRowNum();
        ArrayList<Object> resList = new ArrayList<Object>();
        int n = index = ignoreFirstRow != false ? firstRowIndex + 1 : firstRowIndex;
        while (index <= lastRowIndex) {
            Object obj = ExcelUtil.parseRowData(sheet.getRow(index), clzz);
            if (!Objects.isNull(obj)) {
                resList.add(obj);
            }
            ++index;
        }
        return resList;
    }

    private static Object parseRowData(Row row, Class<?> clzz) throws ActivityCenterException {
        try {
            Field[] fields;
            if (null == row) {
                LOGGER.warn("\u5f53\u524d\u884c\u6570\u636e\u4e3a\u7a7a\uff01");
                return null;
            }
            Object obj = clzz.newInstance();
            for (Field field : fields = clzz.getDeclaredFields()) {
                ExcelRowIndex excelRowIndex = field.getAnnotation(ExcelRowIndex.class);
                if (null == excelRowIndex) continue;
                int rowIndex = excelRowIndex.value();
                Cell cell = row.getCell(rowIndex);
                ExcelUtil.parseCellValueToField(cell, field, obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new ActivityCenterException(ErrorCode.E9999999.getErrorCode(), e.getMessage());
        }
    }

    private static void parseCellValueToField(Cell cell, Field field, Object obj) throws ActivityCenterException {
        String cellValue;
        if (cell == null) {
            return;
        }
        switch (cell.getCellTypeEnum()) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = DateUtils.getSecondStr((Date)cell.getDateCellValue());
                    break;
                }
                cellValue = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            }
            default: {
                cellValue = String.valueOf(cell.getStringCellValue());
            }
        }
        Class<?> fieldType = field.getType();
        field.setAccessible(true);
        ExcelUtil.setValueByFieldType(fieldType, cellValue, field, obj);
    }

    private static <T> void setValueByFieldType(Class<T> fieldType, String cellValue, Field field, Object obj) throws ActivityCenterException {
        String fieldTypeName = fieldType.getSimpleName();
        Class<?> cls = classMap.get(fieldTypeName);
        if (Objects.isNull(cls)) {
            throw new ActivityCenterException(String.format("\u5b57\u6bb5\u7c7b\u578b[%s]\u65e0\u6cd5\u6620\u5c04cell\u503c", fieldTypeName));
        }
        try {
            if (cls == String.class) {
                field.set(obj, cellValue);
            } else {
                field.set(obj, cls.getDeclaredMethod(METHOD_NAME, String.class).invoke(null, cellValue));
            }
        }
        catch (Exception e) {
            throw new ActivityCenterException(String.format("\u5b57\u6bb5[%s]\u6620\u5c04cell\u503c[%s]\u5f02\u5e38", field.getName(), cellValue));
        }
    }

    private static Workbook parseExcelToWorkbook(HttpServletRequest request) throws ActivityCenterException {
        try {
            HSSFWorkbook wb;
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (!multipartResolver.isMultipart(request)) {
                throw new ActivityCenterException(ErrorCode.E9999999);
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile mf = multipartRequest.getFile(REQUEST_PARAM_NAME);
            if (mf == null) {
                throw new ActivityCenterException("\u672a\u89e3\u6790\u5230\u6587\u4ef6\uff01\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
            String fileName = mf.getOriginalFilename();
            String[] split = fileName.split("\\.");
            if (StringUtils.equals((CharSequence)split[1], (CharSequence)FILE_SUFFIX_XLS)) {
                wb = new HSSFWorkbook(mf.getInputStream());
            } else if (StringUtils.equals((CharSequence)split[1], (CharSequence)FILE_SUFFIX_XLSX)) {
                wb = new XSSFWorkbook(mf.getInputStream());
            } else {
                throw new ActivityCenterException("excel\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6309\u6807\u51c6\u683c\u5f0f\u4e0a\u4f20!");
            }
            return wb;
        }
        catch (Exception e) {
            throw new ActivityCenterException(ErrorCode.E9999999.getErrorCode(), e.getMessage());
        }
    }

    static {
        classMap.put(String.class.getSimpleName(), String.class);
        classMap.put(Integer.class.getSimpleName(), Integer.class);
        classMap.put(Integer.TYPE.getSimpleName(), Integer.class);
        classMap.put(Double.class.getSimpleName(), Double.class);
        classMap.put(Double.TYPE.getSimpleName(), Double.class);
        classMap.put(Long.class.getSimpleName(), Long.class);
        classMap.put(Long.TYPE.getSimpleName(), Long.class);
        classMap.put(Boolean.class.getSimpleName(), Boolean.class);
        classMap.put(Boolean.TYPE.getSimpleName(), Boolean.class);
        classMap.put(Date.class.getSimpleName(), Date.class);
    }
}

