package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceStyleDetailDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceStyleDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceStyleInsertDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceStyleUpdateDto;

import java.util.List;

/**
 * @author shenjiaqing
 * @description 广告位样式功能开发
 * @data 2019/11/20
 */
@AdvancedFeignClient
public interface RemoteAdvertisingSpaceStyleService {

    boolean delete(Long id);

    boolean deleteByAdTypeId(Long adTypeId);

    AdvertisingSpaceStyleDto getAdSpaceStyleById(Long id);

    List<Long> getAdStyleIdByAdTypeId(Long adTypeId);

    List<AdvertisingSpaceStyleDto> getAdSpaceStyleByAdTypeId(Long adTypeId);

    List<AdvertisingSpaceStyleDto> getAllAdSpaceStyle();

    List<AdvertisingSpaceStyleDto> getAdSpaceStyleByAdTypeIdList(List<Long> adTypeIdList);

    AdvertisingSpaceStyleDetailDto getAdSpaceStyleDetailById(Long adStyleId);

    boolean templateIdIsExists(String styleStandard, Long id, Long adTypeId);

    boolean adStyleNameIsExists(String adStyleName, Long id, Long adTypeId);

    boolean insert(AdvertisingSpaceStyleInsertDto dto);

    Long insertAndGetId(AdvertisingSpaceStyleInsertDto dto);

    boolean update(AdvertisingSpaceStyleUpdateDto dto);

    boolean adStyleIsExists(Long id);

    Long selectAdTypeIdById(Long id);

    List<AdvertisingSpaceStyleDetailDto> selectByAdTypeId( Long adTypeId);

}
