package cn.com.duiba.tuia.adx.proxy.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.adx.proxy.service.api.constant.AdxTypeEnum;
import cn.com.duiba.tuia.adx.proxy.service.api.dto.creative.CreativeAuditResultDTO;
import cn.com.duiba.tuia.adx.proxy.service.api.dto.creative.CreativeDTO;
import cn.com.duiba.tuia.adx.proxy.service.api.dto.creative.CreativeStatusDTO;
import cn.com.duiba.tuia.adx.proxy.service.api.dto.creative.CreativeStatusQueryDTO;

import java.util.List;

/**
 * 第三方ADX平台创意送审服务
 */
@AdvancedFeignClient
public interface RemoteCreativeService {

    /**
     * 送审创意
     * @param creativeDTOList
     * @param adxType
     * @return
     * @throws BizException
     */
    List<CreativeAuditResultDTO> audit(List<CreativeDTO> creativeDTOList, AdxTypeEnum adxType) throws BizException;

    /**
     * 查询创意审核状态
     * @param creativeStatusQueryDTOList
     * @param adxType
     * @return
     * @throws BizException
     */
    List<CreativeStatusDTO> queryAuditStatus(List<CreativeStatusQueryDTO> creativeStatusQueryDTOList, AdxTypeEnum adxType)throws BizException;

    /**
     * 新架构-送审创意
     */
    List<CreativeAuditResultDTO> auditV4(List<CreativeDTO> creativeDTOList, AdxTypeEnum adxType) throws BizException;

    /**
     * 新架构-查询创意审核状态
     */
    List<CreativeStatusDTO> queryAuditStatusV4(List<CreativeStatusQueryDTO> creativeStatusQueryDTOList, AdxTypeEnum adxType)throws BizException;
}
