package cn.com.duiba.tuia.algo.engine.api.adx;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 大媒体视频对象
 *
 * @author peanut.huang
 * @date 2020/4/23
 * @since JDK 1.8
 */
@Data
@Accessors(chain = true)
public class VipVideoInfo implements Serializable {

    private static final long serialVersionUID = -5952917146163379256L;
    /**
     * 爱奇艺视频
     */
    private IQiYiVideo              iQiYiVideo;

    /**
     * 芒果视频
     */
    private MgVideo                 mgVideo;

    /**
     * 百度视频
     */
    private BaiduVideo              baiduVideo;


    /**
     * 爱奇艺视频
     */
    @Data
    @Accessors(chain = true)
    public static class IQiYiVideo implements Serializable {

        private static final long serialVersionUID = 1993608957280551472L;
        /**
         * 视频频道id
         */
        private Integer channelId;

        /**
         * 视频标题
         */
        private String title;

        /**
         * 视频网址
         */
        private String url;

        /**
         * 视频时长
         */
        private Integer len;

        /**
         * 视频国家id
         */
        private Integer country;

        /**
         * 视频省份id
         */
        private Integer metro;

        /**
         * 视频城市id
         */
        private Integer city;

        /**
         * 视频 geoHash
         */
        private String geoHash;

        /**
         * 剧目信息
         */
        private Integer albumId;

        /**
         * 投放平台信息id
         */
        private Integer platformId;

        /**
         * 广告类型，创意类型id
         */
        private Integer adTypeId;
    }

    /**
     * 芒果视频
     */
    @Data
    @Accessors(chain = true)
    public static class MgVideo implements Serializable {

        private static final long serialVersionUID = -6762102784189492753L;

        /**
         * 视频id
         */
        private Integer videoId;

        /**
         * 视频名称
         */
        private String videoName;

        /**
         * 视频链接网址
         */
        private String videoUrl;

        /**
         * 视频所述合集id
         */
        private Integer collectionId;

        /**
         * 视频所述合集名称
         */
        private String collectionName;

        /**
         * 视频频道id
         */
        private Integer channelId;

        /**
         * 视频二级分类id
         */
        private String itemIds;

        /**
         * 视频二级分类名称
         */
        private String itemNames;

        /**
         * 视频所属地区id
         */
        private Integer areaId;

        /**
         * 视频所属地区名称
         */
        private String areaName;

        /**
         * 视频出品年代
         */
        private Integer year;

        /**
         * 视频时长，单位秒
         */
        private Integer duration;

        /**
         * 片源，1-正片，2-短片
         */
        private Integer videoType;

        /**
         * 城市识别码
         */
        private Integer cityCode;

        /**
         * 广告类型，创意类型id
         */
        private Integer location;
    }


    /**
     * 百度视频
     */
    @Data
    public static class BaiduVideo implements Serializable {

        private static final long serialVersionUID = 1091665433509772191L;

        /**
         * 视频标题
         */
        private String title;

        /**
         * 视频网址
         */
        private String url;

        /**
         * 视频时长
         */
        private Integer contentLength;

        /**
         * 视频频道id
         */
        private Integer channelId;

        /**
         * 省份id
         */
        private String province;

        /**
         * 城市id
         */
        private String city;

        /**
         * 地区id
         */
        private String district;

        /**
         * 街道id
         */
        private String street;

        /**
         * 广告类型，创意类型id
         */
        private Integer adSlotType;

        /**
         * 页面类型
         */
        private Integer pageType;
    }
}
