package cn.com.duiba.tuia.algo.engine.api.adx;

import cn.com.duiba.tuia.activity.center.api.constant.adx.IdeaPKTypeEnum;
import cn.com.duiba.tuia.activity.center.api.constant.adx.PriceType;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * adx 创意pk结果
 *
 * @author peanut.huang
 * @date 2020/1/14 17:10
 */
@Data
@ToString
@Accessors(chain = true)
public class AdxAlgoPkResult implements Serializable {
    private static final long serialVersionUID = -8295685668431881019L;

    /**
     * adx链路唯一标识
     */
    private String                  adxRid;

    /**
     * 胜出的创意ID
     */
    private Long                    ideaId;

    /**
     * 参与收益pk的创意集合
     */
    private List<Long>              ideaList;

    /**
     * 互动创意出价（分/cpm）
     */
    private Long                    interPrice;

    /**
     * 互动创意rpm (分/千次竞价)
     */
    private Double                  interRpm;

    /**
     * 直投创意出价（分/cpm）
     */
    private Long                    directlyPrice;

    /**
     * 直投创意rpm (分/千次竞价)
     */
    private Double                  directlyRpm;

    /**
     * 胜出的创意特征JSON
     */
    private Map<String, String>     features;

    /**
     * pk评判标准：{@link IdeaPKTypeEnum#getType()}
     */
    private Integer                 pkType;

    /**
     * 创意出价类型 {@link PriceType#getType}
     */
    private Integer                 priceType;
}
