package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.plant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.FinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.LotteryDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PropDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PlantPropReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.PlantV5UserReq;

/**
 * RemotePlantV5Service
 *
 * @author huangruodan
 * @date 2019-07-21
 */

@AdvancedFeignClient
public interface RemotePlantV5Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(PlantV5UserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req      用户参数
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantV5UserReq req) throws BizException;

    /**
     * 采摘红包
     *
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantV5UserReq req) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req 用户参数、missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(FinishMissionReq req) throws BizException;



    /**
     * 用户使用道具，
     *
     * @param req landId,propTye,user
     * @return
     * @throws BizException
     */
    PropDto useProp(PlantPropReq req) throws BizException;

    /**
     * @param req
     * @return
     * @throws BizException
     */
    LotteryDto lotteryEveryday(PlantV5UserReq req) throws BizException;


    /**
     * @param req
     * @return
     * @throws BizException
     */
    int finishVat(CommercialUserReq req) throws BizException;

    /**
     * 换天接口
     * @param req deviceId、appId、date
     * @return
     * @throws BizException
     */
    Boolean resetForTest(ResetForTestReq req) throws BizException;
}
