package cn.com.duiba.tuia.commercial.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.story.plant.PlantDto;
import cn.com.duiba.tuia.commercial.center.api.dto.story.plant.req.StoryFinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.plant.req.StoryPlantReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.user.req.StoryUserReq;

;

/**
 * [商业化活动]种红包Remote接口
 *
 * @author zhangbaiqiang
 * @date 2019-03-08
 */
@AdvancedFeignClient
public interface RemoteStoryPlantService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(StoryUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param plantReq req 用户参数 landId 土地编号 seedType 种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(StoryPlantReq plantReq) throws BizException;

    /**
     * 采摘红包
     *
     * @param plantReq 用户参数、种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(StoryPlantReq plantReq) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param missionReq req 用户参数 missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(StoryFinishMissionReq missionReq) throws BizException;

    /**
     * 领取场景任务奖励
     *
     * @param missionReq req 用户参数 missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishSceneMission(StoryFinishMissionReq missionReq) throws BizException;

    /**
     * 获取种红包奖励配置
     *
     * @return 种红包奖励配置
     */
    PlantConfigDto queryPrizeConfig() throws BizException;

    /**
     * 更新奖励配置参数(慎用)
     *
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantConfig(PlantConfigDto configDto) throws BizException;
}
