package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.plant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.hb.DeductScoreConfig;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.FinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.config.PlantConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PlantReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

/**
 * [商业化活动]种红包Remote接口
 *
 * @author zhangbaiqiang
 * @date 2019-03-08
 */
@AdvancedFeignClient
public interface RemotePlantV3Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(CommercialUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param plantReq 用户参数,土地编号,种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantReq plantReq) throws BizException;

    /**
     * 采摘红包
     *
     * @param plantReq 用户参数、种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantReq plantReq) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param missionReq 用户参数、任务id
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(FinishMissionReq missionReq) throws BizException;

    /**
     * 获取种红包奖励配置
     *
     * @return 种红包奖励配置
     */
    PlantConfigDto queryPrizeConfig(Long activityId) throws BizException;

    /**
     * 更新奖励配置参数(慎用)
     *
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantConfig(Long activityId, PlantConfigDto configDto) throws BizException;

    /**
     * [测试用接口]清除缓存
     *
     * @param req 设备id、媒体id、签到日期
     */
    Boolean resetForTest(ResetForTestReq req);

    /**
     * 完成增值任务（红包雨/宝箱）
     */
    int finishVat(CommercialUserReq req) throws BizException;

    /**
     * 更新积分消耗配置
     */
    DeductScoreConfig updateDeductScoreConfig(Long appId, DeductScoreConfig config) throws BizException;

    void deletePlantConfigFromRedis(Long activityId);
}
