package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.FarmPrizeDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * FarmFinanceRewardDto
 *
 * @author huangruodan
 * @date 2019-11-27
 */

@Data
public class FarmFinanceRewardDto implements Serializable {

    private static final long serialVersionUID = -7522986378624562463L;

    private Long totalCash;

    private Integer totalRedPacketNum;

    /**
     * 待领取金币数量
     */
    private Long unclearCash;

    /**
     * 待领取红包数
     */
    private Integer unclearRedPacket;

    private List<FarmPrizeDto> prizeList;

    /**
     * 本周期剩余时间（秒数）
     */
    private Long restSeconds;

    /**
     * 翻倍倍数
     */
    private Integer multiple;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 用户金币信息
     */
    private FarmUserCashDto user;

    /**
     * 剩余补足次数
     */
    private Integer restTimes;

    /**
     * 需要补足的金币数
     */
    private Long restCash;

    private Integer conditionType;


}
