package cn.com.duiba.tuia.commercial.center.api.constant.richman;

import cn.tuia.mango.core.enums.CodeDescriptionEnumerable;
import cn.tuia.mango.core.util.EnumKit;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;

/**
 * @author lijicong
 * @since 2020-04-11
 */
public abstract class RichmanEnums {

    // 媒体类型 0:不提供奖品 1:提供奖品
    @Getter
    @AllArgsConstructor
    public enum MediaTypeEnum implements CodeDescriptionEnumerable<String, String> {
        MEDIA_TYPE_0("0", "不提供奖品"),
        MEDIA_TYPE_1("1", "提供奖品"),
        ;

        private String code;
        private String description;

        public static Optional<MediaTypeEnum> of(String code) {
            return EnumKit.of(MediaTypeEnum.class, code);
        }
    }

    // 开发者订单状态 0:预扣 1:成功 2:失败
    @Getter
    @AllArgsConstructor
    public enum OrderStatusEnum implements CodeDescriptionEnumerable<String, String> {
        ORDER_STATUS_0("0", "预扣"),
        ORDER_STATUS_1("1", "成功"),
        ORDER_STATUS_2("2", "失败"),
        ;

        private String code;
        private String description;

        public static Optional<OrderStatusEnum> of(String code) {
            return EnumKit.of(OrderStatusEnum.class, code);
        }
    }
}
