package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户贡献任务
 * Created by zxw on 2021-01-08.
 */

@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class FarmContributionUserMissionDto implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "任务类型")
    private Integer conditionType;

    @ApiModelProperty(value = "任务类型")
    private String createDate;

    @ApiModelProperty(value = "任务内容描述")
    private String missionDesc;

    @ApiModelProperty(value = "当前值")
    private Long currentValue;

    @ApiModelProperty(value = "任务需求值")
    private Integer conditionValue;

    @ApiModelProperty(value = " 插件id")
    private Long pluginId;

    @ApiModelProperty(value = "0 现金 1 虚拟奖品 2 券码 3 实物")
    private Integer prizeType;

    @ApiModelProperty(value = "消耗金额")
    private Integer amount;

    @ApiModelProperty(value = "奖励内容描述")
    private String prizeDesc;

    @ApiModelProperty(value = "状态")
    private Integer status;

    @ApiModelProperty(value = "过期时间")
    private Date expireTime;

    @ApiModelProperty(value = "奖品图片")
    private String prizePic;

    @ApiModelProperty(value = "是否展示")
    private Boolean show;

    @ApiModelProperty(value = "库存")
    private Long stockNum;

    @ApiModelProperty(value = "是否是VIP任务，0->非VIP任务，1->VIP任务")
    private Integer vipMission;

}
