package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * FarmFacilityConfigDto
 * 设施配置信息
 * @author huangruodan
 * @date 2019-11-21
 */
@Data
public class FarmFacilityConfigDto implements Serializable {
    private static final long serialVersionUID = 1008604105177837661L;

    /**
     * id
     */
    private Long id;

    /**
     * 设施类型
     */
    private Integer facilityType;


    /**
     * 设施名称
     */
    private String facilityName;

    /**
     * 等级
     */
    private Integer facilityLevel;

    /**
     * 奖励数量
     */
    private Integer prizeAmount;

    /**
     * 奖励数量扩展（JSON数组)
     */
    private String prizeAmountExt;

    /**
     * 消耗金币数
     */
    private Integer cashUpgrade;

    /**
     * 奖励周期
     */
    private Integer prizePeriod;

    /**
     * 冷却时间(秒)
     */
    private Integer coolDown;

    /**
     * 图片url
     */
    private String imageUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新事件
     */
    private Date gmtModified;

    /**
     * 奖励系数
     */
    private Double prizeCoefficient;

    private Integer configVersion;


}
