package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/*
离线收益配置DTO
 */
@Setter
@Getter
public class SynConfigOfflineIncomeDTO implements Serializable {

    private static final long serialVersionUID = 5161401939576111473L;

    private Long id;

    private Integer configVersion;

    @ApiModelProperty(value = "离线收益占比正常收益")
    @ExcelRowIndex
    private Integer offlineRatio;

    @ApiModelProperty(value = "离线收益开始计算时间（秒）")
    @ExcelRowIndex(1)
    private Integer offlineStartSeconds;

    @ApiModelProperty(value = "离线收益累积收益最长时间（秒）")
    @ExcelRowIndex(2)
    private Integer offlineMaxSeconds;

    @ApiModelProperty(value = "初始金币")
    @ExcelRowIndex(3)
    private Long initCoin;

    @ApiModelProperty(value = "合成出券时机")
    @ExcelRowIndex(4)
    private String compoundCouponChance;

    @ApiModelProperty(value = "礼包奖励出券时机")
    @ExcelRowIndex(5)
    private String giftPrizeCouponChance;

    @ApiModelProperty(value = "现金翻倍次数限制")
    @ExcelRowIndex(6)
    private Integer cashDoubleLimit;

    @ApiModelProperty(value = "离线翻倍次数限制")
    @ExcelRowIndex(7)
    private Integer offlineDoubleLimit;

    @ApiModelProperty(value = "离线翻倍次数限制")
    @ExcelRowIndex(8)
    private String heavenTimes;

    private Date gmtCreate;

    private Date gmtModified;

}
