package cn.com.duiba.tuia.commercial.center.api.dto.farm.req;

import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmCommonDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmDoubleConfigDto;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/2/20 11:35 上午
 */
@Data
@Builder
public class FarmDoubleRewardResultReq implements Serializable {

    private static final long serialVersionUID = 93999354233852541L;
    /**
     * 翻倍金额
     */
    private Long rewardCash;

    /**
     * 翻倍配置
     */
    private FarmDoubleConfigDto config;

    /**
     * 用户信息
     */
    private FarmCommonDto common;

    /**
     * 当日次数
     */
    private Map<Integer, Integer> curTimesMap;

    /**
     * 翻倍场景类型 {@link FarmDoubleRewardConditionType}
     */
    private Integer conditionType;

    /**
     * 配置版本号
     */
    private Integer configVersion;

    /**
     * 今日参与次数
     */
    private Integer todayTimes;
}
