package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * [合成游戏]宠物表
 */
@Getter
@Setter
public class SynPetDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "宠物ID")
    private Long id;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

    @ApiModelProperty(value = "宠物名称")
    @ExcelRowIndex(0)
    private String petName;

    @ApiModelProperty(value = "宠物等级")
    @ExcelRowIndex(1)
    private Integer petGrade;

    @ApiModelProperty(value = "每秒收益")
    @ExcelRowIndex(2)
    private Long secondIncome;

    @ApiModelProperty(value = "基础金币")
    @ExcelRowIndex(3)
    private Long petPrice;

    @ApiModelProperty(value = "金币购买递增量")
    @ExcelRowIndex(4)
    private Long buyIncrement;

    @ApiModelProperty(value = "购买最大金币")
    @ExcelRowIndex(5)
    private Long buyMaxPrice;

    @ApiModelProperty(value = "回收价格")
    @ExcelRowIndex(6)
    private Long recyclePrice;

    @ApiModelProperty(value = "可购宠物等级")
    @ExcelRowIndex(7)
    private Integer buyPetGrade;

    @ApiModelProperty(value = "下一宠物ID")
    @ExcelRowIndex(8)
    private Integer dropGiftPetGrade;

    @ApiModelProperty(value = "宠物图片")
    @ExcelRowIndex(9)
    private String petImg;

    @ApiModelProperty(value = "宠物图片(未解锁)")
    @ExcelRowIndex(10)
    private String unlockedPetImg;
}