package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-05-27
 */
@Setter
@Getter
public class SynthesisDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户信息")
    private SynUserDTO user;

    @ApiModelProperty(value = "用户新手引导信息")
    private UserGuideDTO userGuide;

    @ApiModelProperty(value = "用户现金信息")
    private SynUserCashDTO userCash;

    @ApiModelProperty(value = "用户离线金币收益")
    private OfflineGoldDTO offlineGold;

    @ApiModelProperty(value = "宠物信息")
    private List<SynPetDTO> pets;

    @ApiModelProperty(value = "可购宠物")
    private QuickBuyInfoDTO quickBuyInfo;

    @ApiModelProperty(value = "用户三日礼")
    private SynInitCashDTO thirdGift;

    @ApiModelProperty(value = "是否领取过天降礼包")
    private Boolean heavenGift;

    @ApiModelProperty(value = "累计登录天数")
    private Integer cumulativeLogin;

    @ApiModelProperty(value = "用户曝光卷配置")
    private SynUserGiftConfigDTO ticketConfig;

    @ApiModelProperty(value = "美食场景")
    private SynFoodSceneDTO foodScene;

    @ApiModelProperty(value = "服务器时间")
    private Date serverTime;

    @ApiModelProperty(value = "定制用户额外增长速率")
    private ExtraRationDTO extraRationDTO;

    @ApiModelProperty(value = "天降礼包间隔")
    private List<Integer> heavenTimes;

    @ApiModelProperty(value = "天降礼包当前第几次")
    private Integer currentHeavenTimes;

    @ApiModelProperty(value = "icon点击次数")
    private Integer iconClickTimes;

    @ApiModelProperty(value = "是否可以签到")
    private Boolean canSign;

    @ApiModelProperty(value = "看视频次数")
    private Integer rewardVideoTimes;


    @Setter
    @Getter
    public static class UserGuideDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "新手引导步骤")
        private Integer guideStep;

        @ApiModelProperty(value = "新人礼包奖励")
        private Integer newGiftsAmount;

        @ApiModelProperty(value = "宠物名称")
        private String petName;

        @ApiModelProperty(value = "宠物等级")
        private Integer petGrade;

        @ApiModelProperty(value = "宠物图片")
        private String petImg;
    }

    @Setter
    @Getter
    public static class QuickBuyInfoDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "可购宠物ID")
        private Long buyPetId;

        @ApiModelProperty(value = "可购宠物等级")
        private Integer buyPetGrade;

        @ApiModelProperty(value = "宠物价格")
        private Long petPrice;
    }

    @Setter
    @Getter
    public static class OfflineGoldDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "离线收益时长/秒")
        private Long offlineTime;

        @ApiModelProperty(value = "到达上限")
        private Boolean reachedLimit;

        @ApiModelProperty(value = "离线收益")
        private Long coin;

        @ApiModelProperty(value = "奖励")
        private SynRewardDTO reward;

    }

    @Setter
    @Getter
    public static class SynFoodSceneDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "美食序号")
        private Long foodSn;

        @ApiModelProperty(value = "气泡文字")
        private String popText;

        @ApiModelProperty(value = "场景名称")
        private String sceneName;

        @ApiModelProperty(value = "场景图片")
        private String sceneImg;

        @ApiModelProperty(value = "是否有红点提示")
        private Boolean hasRedTips = false;

    }
}
