package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmSignDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmSignInfoDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmUserSignInfoDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFarmSignService {


    /**
     * 签到列表接口
     *
     * @param userReq
     * @return
     */
    List<FarmSignInfoDto> getUserSignList(FarmUserReq userReq) throws BizException;


    /**
     * 用户签到
     *
     * @return
     * @req
     */
    FarmSignDto userSign(FarmUserReq req) throws BizException;


    /**
     * 用户签到v2
     * @param req
     * @return
     * @throws BizExcep
     */
    FarmDto userSignV2(FarmUserReq req) throws BizException;

    /**
     * 签到列表v2
     * @param req
     * @return
     */
    List<FarmUserSignInfoDto> getUserSignListV2(FarmUserReq req) throws BizException;


}
