package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.FarmBaseUserDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;

@AdvancedFeignClient
public interface RemoteFarmUserService {

    FarmBaseUserDto queryBaseUser(FarmUserReq farmUserReq);

    /**
     * <p> 获取用户基本信息
     * @param req
     * @param force  force==1 则击穿redis，直接从墨迹获取是否是会员的信息
     * @return  1->会员；0->非会员；null->查询异常
     */
    Integer getFarmUserVip(FarmUserReq req, Integer force);

    /**
     * 用户id覆盖设备号 解绑
     * @param req
     */
    void unboundUser(FarmUserReq req);
}
