package cn.com.duiba.tuia.commercial.center.api.remoteservice.taobao;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.common.taobao.TaobaoItemDto;

import java.util.List;
import java.util.Map;

/**
 * RemoteSpreadService
 * Created by zxw on 2021-06-02.
 */

@AdvancedFeignClient
public interface RemoteTaobaoItemService {

    /**
     * 根据点位获取ids
     * @return
     */
    List<Long> getItemIdsByType(String type);

    /**
     * 分页查询
     * @param pageNo
     * @param type
     * @return
     */
    List<TaobaoItemDto> getInfoByPage(Integer pageNo, String type);

    /**
     * 获取点位广告idsmap
     * @return
     */
    Map<String, List<Long>> getNonMandatoryMap();

    /**
     * 根据id出广告
     * @param id
     * @return
     */
    TaobaoItemDto findById(Long id);
    /**
     * @description     <p>feeds流返回商品从历史数据来看命中用户需求概率较低，需将每个tab下方前4个坑位的商品改为人工选（从自选物料返回为准）
     *                  3个tab下方前4个坑位商品调整为人工选品（自选物料返回）
     * @author cuiwx 2022/2/15
     * @return 
     */
    Map<String,List<TaobaoItemDto>> getNonMandatoryItemDtoMap();

}
