package cn.com.duiba.tuia.commercial.center.api.remoteservice.travel;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.travel.TravelAwardDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.travel.TravelUserMissionDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.travel.req.EntranceActivityRequestDTO;

import java.util.List;

/**
 * @ClassName RemoteTravelMissionService
 * @Description
 * @Author zaizai
 * @Date 2021/8/9 9:48 上午
 */
@AdvancedFeignClient
public interface RemoteTravelMissionService {

    /**
     * 获取任务列表
     * @param entranceActivityRequestDTO
     * @param cityCode
     * @return
     * @throws BizException
     */
    List<TravelUserMissionDTO> getMissionList(EntranceActivityRequestDTO entranceActivityRequestDTO, String cityCode) throws BizException;

    /**
     * 完成任务
     * @param entranceActivityRequestDTO
     * @param missionCode
     * @param cityCode
     * @return
     * @throws BizException
     */
    TravelUserMissionDTO finishMission(EntranceActivityRequestDTO entranceActivityRequestDTO, String missionCode, String cityCode) throws BizException;

    /**
     * 领取任务奖励
     * @param entranceActivityRequestDTO
     * @param missionCode
     * @param cityCode
     * @return
     */
    TravelUserMissionDTO receiveMissionAward(EntranceActivityRequestDTO entranceActivityRequestDTO, String missionCode, String cityCode) throws BizException;

    /**
     *  签到或补签
     * @param entranceActivityRequestDTO
     * @param missionCode
     * @param cityCode
     * @return
     * @throws BizException
     */
    TravelUserMissionDTO sign(EntranceActivityRequestDTO entranceActivityRequestDTO, String missionCode, String cityCode) throws BizException;

}
