package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.BalanceRecordDto;
import cn.com.duiba.tuia.ecb.center.dto.UserBalanceDto;
import cn.com.duiba.tuia.ecb.center.enums.ChangeTradeCode;

import java.util.List;

/**
 * 用户账户信息
 * Created by xuefeng on 2019/4/8.
 */
@AdvancedFeignClient
public interface RemoteUserBalanceService {

    /**
     * 获取用户默认账户余额
     * @param userId
     * @return
     */
    Long getDefaultBalance(Long userId);

    /**
     * 查询用户流水记录数
     * @param userId
     * @return
     */
    Long queryDefaultCountByUserId(Long userId);

    /**
     * 分页查询用户默认账户流水记录
     * @param userId
     * @param currentPage
     * @param pageSize
     * @return
     */
    List<BalanceRecordDto> queryUserDefaultOrder(Long userId, Integer currentPage, Integer pageSize);

    /**
     * 查询用户指定收入类型流水
     * @param userId
     * @param code
     * @return
     */
    Integer queryOrderCountByCode(Long userId, Integer code);

    /**
     * 更新默认账户余额
     * @param userId
     * @param fee
     * @param code
     * @return
     */
    Long defaultBalanceChange(Long userId, Long fee, ChangeTradeCode code);

    /**
     * 创建账户
     * @param userId
     * @param fee
     * @return
     */
    Boolean loadBalance(Long userId, Long fee);
}
