package cn.com.duiba.tuia.ecb.center.common.enums;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author huangruodan
 * @version 创建时间：2020/3/16 5:42 下午
 */
public enum OperatorType {
    DEFAULT(0, "未知"),
    YD(1, "中国移动"),
    DX(2, "中国电信"),
    LT(3, "中国联通"),
    OTHER(99, "其他运营商");

    private Integer type;

    private String desc;

    OperatorType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getType() {
        return type;
    }
    public static OperatorType getByType(Integer type) {
        List<OperatorType> list = Lists.newArrayList(OperatorType.values())
                .stream()
                .filter(input -> input.type.equals(type))
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return OperatorType.DEFAULT;
    }
}
