package cn.com.duiba.tuia.ecb.center.draw.dto.enums;


import java.util.Objects;

/**
 * 抽奖活动类型
 */
public enum DrawActivityTypeEnum {

    PERIOD(0, "周期活动"),
    DAILY(1, "每日活动"),
    PERIOD_EXCHANGE(2, "周期兑换"),
    ;

    private int code;
    private String desc;

    DrawActivityTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static Boolean isPeriodExchangeActivity(Integer activityType)  {
        return Objects.equals(activityType, DrawActivityTypeEnum.PERIOD_EXCHANGE.getCode());
    }

}
