package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixAppDayIncomeDto;
import cn.com.duiba.tuia.ecb.center.mix.req.AppIncomeReq;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteMixAppIncomeService {

    List<MixAppDayIncomeDto> selectAppDayIncomeByAppIds(AppIncomeReq appIncomeReq);

    Boolean updateBatchAppDayIncome(List<MixAppDayIncomeDto> appDayIncomeDtos);

    Boolean saveAppDayIncome(MixAppDayIncomeDto appDayIncomeDto) throws BizException;

    /**
     * 从缓存中查询媒体日收益
     *
     * @param appId 媒体id
     * @param date 日期
     * @return 媒体日收益
     */
    Long queryAppDayIncomeCache(Long appId, Date date);

    /**
     * 从缓存中查询广告位日收益
     *
     * @param slotId 广告位id
     * @param date 日期
     * @return 媒体日收益
     */
    Long querySlotDayIncomeCache(Long slotId, Date date);
}
