package cn.com.duiba.tuia.ecb.center.fl.enums;

import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyCardDto;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Random;

public enum FiveLuckyType {
    HX("hx", "和谐福"),
    YS("ys", "友善福"),
    FQ("fq", "富强福"),
    AG("ag", "爱国福"),
    JY("jy", "敬业福"),
    ;

    private String name;
    private String desc;

    FiveLuckyType(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    /**
     * 出一张随机福卡
     * @return
     */
    public static FiveLuckyType getRandom() {
        FiveLuckyType[] types = {HX, YS, FQ, JY};
        return types[new Random().nextInt(4)];
    }

    /**
     * 福卡个数+1
     * @param fiveLucks
     * @param type
     * @return
     */
    public static void add(List<FiveLuckyCardDto> fiveLucks, FiveLuckyType type) {
        if (CollectionUtils.isEmpty(fiveLucks)) {
            return;
        }
        for (FiveLuckyCardDto fiveLuck : fiveLucks) {
            if (type.getName().equals(fiveLuck.getName())) {
                fiveLuck.add();
            }
        }
    }
}
