package cn.com.duiba.tuia.ecb.center.video.dto.video;

import com.alibaba.fastjson.JSONArray;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/4/10 4:36 下午
 */
@Data
public class ThirdVideoReportDataDto implements Serializable {

    private static final long serialVersionUID = 2159356657614113017L;
    /**
     * 曝光
     */
    private JSONArray show;

    /**
     * 点击
     */
    private JSONArray cardClick;

    /**
     * 视频开始播放
     */
    private JSONArray start;

    /**
     * 跳过
     */
    private JSONArray skip;

    /**
     * 关闭视频
     */
    private JSONArray videoClose;

    /**
     * 视频播放结束
     */
    private JSONArray end;

    /**
     * 开始下载
     */
    private JSONArray startDownload;

    /**
     * 下载完成
     */
    private JSONArray downloadEnd;

    /**
     * 开始安装
     */
    private JSONArray startInstall;

    /**
     * 安装完成
     */
    private JSONArray installEnd;

    /**
     * 视频加载失败
     */
    private JSONArray videoLoadingError;

    /**
     * 视频加载完成
     */
    private JSONArray videoLoaded;

    /**
     * 播放视频静音
     */
    private JSONArray mute;

    /**
     * 取消静音
     */
    private JSONArray cancelMute;

    /**
     * 曝光落地页
     */
    private JSONArray showLand;

    /**
     * 点击落地页
     */
    private JSONArray clickLand;

    /**
     * 关闭落地页
     */
    private JSONArray closeLand;

    /**
     * 在用户点击横幅广告时调用，并打开落地页 strLinkUrl
     */
    private JSONArray clickTrack;

    /**
     * 视频暂停播放上报
     */
    private JSONArray videoSuspend;

    /**
     * 视频取消暂停上报
     */
    private JSONArray videoCancelSuspend;

    /**
     * 视频播放X毫秒后上报，格式为map ，key为播放需要上报时间,value为数组,
     */
    private Map<String, Object> afterPlay;

    private JSONArray video50Percent;

    private JSONArray video75Percent;

    private JSONArray video25Percent;

    /**
     * app激活完成
     */
    private JSONArray activeApp;

    /***
     * app安装后打开
     */
    private JSONArray installOpenApp;

    private JSONArray videoClick;

    /**
     * 全屏
     */
    private JSONArray full;

    /**
     * endcardhtml 展示时上报
     */
    private JSONArray endCardHtmlExposure;

    /**
     * endcardhtml 关闭时上报
     */
    private JSONArray endCardHtmlClose;

    /**
     * deepLinkUrl跳转时上报
     */
    private JSONArray deepLinkClick;

}
