/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ecb.center.fl.enums;

import cn.com.duiba.tuia.ecb.center.fl.dto.FiveLuckyCardDto;
import java.util.List;
import java.util.Random;
import org.springframework.util.CollectionUtils;

public enum FiveLuckyType {
    HX("hx", "\u548c\u8c10\u798f"),
    YS("ys", "\u53cb\u5584\u798f"),
    FQ("fq", "\u5bcc\u5f3a\u798f"),
    AG("ag", "\u7231\u56fd\u798f"),
    JY("jy", "\u656c\u4e1a\u798f");

    private String name;
    private String desc;

    private FiveLuckyType(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public static FiveLuckyType getRandom() {
        FiveLuckyType[] types = new FiveLuckyType[]{HX, YS, FQ, JY};
        return types[new Random().nextInt(4)];
    }

    public static FiveLuckyType getRandom(String name) {
        FiveLuckyType[] types = new FiveLuckyType[3];
        int i = 0;
        for (FiveLuckyType value : FiveLuckyType.values()) {
            if (value == AG || value.getName().equals(name) || i > 2) continue;
            types[i++] = value;
        }
        return types[new Random().nextInt(3)];
    }

    public static void add(List<FiveLuckyCardDto> fiveLucks, FiveLuckyType type) {
        if (CollectionUtils.isEmpty(fiveLucks)) {
            return;
        }
        for (FiveLuckyCardDto fiveLuck : fiveLucks) {
            if (!type.getName().equals(fiveLuck.getName())) continue;
            fiveLuck.add();
        }
    }

    public static FiveLuckyType getFixed(String name) {
        FiveLuckyType[] types;
        for (FiveLuckyType type : types = new FiveLuckyType[]{HX, YS, FQ, JY}) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return FiveLuckyType.getRandom();
    }

    public static void reduce(List<FiveLuckyCardDto> fiveLucks, FiveLuckyType type) {
        if (CollectionUtils.isEmpty(fiveLucks) || type == null) {
            return;
        }
        for (FiveLuckyCardDto fiveLuck : fiveLucks) {
            if (!type.getName().equals(fiveLuck.getName())) continue;
            fiveLuck.reduce();
        }
    }

    public static FiveLuckyType getFourLuckyByName(String name) {
        FiveLuckyType[] types;
        for (FiveLuckyType type : types = new FiveLuckyType[]{HX, YS, FQ, JY}) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }
}

